﻿var portals = {
    context: $(".v-portals"),
    canModifySettings: $("#ModifyReportingAccess").val() == "True",
    datatable: null,
    refreshDataTable: function () {
        portals.datatable.a4datatable("refresh");
    },
    initializeDataTable: function () {
        this.datatable = $(".v-portalsTable").a4datatable({
            advancedFilter: true,
            height: "full",
            stateKey: "ReportingPortals",
            ajaxAction: a4.getAction("GetPortals", "Reporting", "Settings"),
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "HideInSelector": true },
                { "Name": "Active", "Title": resources.Status, "Data": "ActiveLabel", "Type": "boolean", "AdvancedFilterLabels": { "0": resources.Inactive, "1": resources.Active } },
                { "Name": "Description", "Title": resources.Description, "Data": "Description" }
            ],
            toolBarItems: portals.getToolBarItems(),
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                switch (action) {
                    case "delete":
                        portals.deleteItems(ids);
                        break;
                }
            },
            contextMenuItems: portals.getContextMenuItems(),
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditPortal", "Reporting", "Settings", { id: row.Id }), row.UseDefaultTheme ? 450 : 700, 750, { afterClose: function () { portals.refreshDataTable(); } });
                        break;
                    case "delete":
                        portals.deleteItems([row.Id]);
                        break;
                    case "editUsers":
                        modalDialog.showWindow(a4.getAction("UserSelector", "Reporting", "Settings", { portalId: row.Id }), 660, 800);
                        break;
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.Active, "AjaxParams": { "active": true } },
                    { "Label": resources.Inactive, "AjaxParams": { "active": false } }
                ]
            },
            localizableTexts: { "All": resources.AllPortals, "Search": resources.SearchPortals }
        });
    },
    bindEvents: function () {
        $(document).on("click", ".h-addPortal", function () {
            modalDialog.showWindow(a4.getAction("EditPortal", "Reporting", "Settings"), 450, 750, { afterClose: function () { portals.refreshDataTable(); } });
        });
    },
    deleteItems: function (items) {
        modalDialog.showConfirmDelete(confirmDeletePortalsResources, function () {
            a4.callServerMethod(a4.getAction("DeletePortals", "Reporting", "Settings"), { ids: items },
                function (result) {
                    portals.refreshDataTable();
                });
        }, items.length);
    },
    getContextMenuItems: function () {
        var items = [];
        if (this.canModifySettings) {
            items = [                
                { "Action": "editUsers", "Label": resources.EditUsers },
                { "Divider": true },
                { "Action": "delete", "Label": resources.Delete },
                { "Action": "properties", "Label": resources.Properties },
            ]
        }
        return items;
    },
    getToolBarItems: function () {
        var items = [];
        if (this.canModifySettings) {
            items = [
               { "Action": "delete", "Label": resources.Delete }
            ]
        }
        return items;
    }
}

$(document).ready(function () {
    if (portals.context.length > 0) {
        portals.initializeDataTable();
        portals.bindEvents();
    }
});